/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.xobject;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.processors.impl.SvgProcessorResult;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.PdfRootSvgNodeRenderer;

public class SvgImageXObject
extends PdfFormXObject {
    private final ISvgProcessorResult result;
    private final ResourceResolver resourceResolver;
    private boolean isGenerated = false;

    public SvgImageXObject(Rectangle bBox, ISvgProcessorResult result, ResourceResolver resourceResolver) {
        super(bBox);
        this.result = result;
        this.resourceResolver = resourceResolver;
    }

    public ISvgProcessorResult getResult() {
        return this.result;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void generate(PdfDocument document) {
        if (!this.isGenerated) {
            PdfCanvas canvas = new PdfCanvas((PdfFormXObject)this, document);
            SvgDrawContext context = new SvgDrawContext(this.resourceResolver, this.result.getFontProvider());
            if (this.result instanceof SvgProcessorResult) {
                context.setCssContext(((SvgProcessorResult)this.result).getContext().getCssContext());
            }
            context.addNamedObjects(this.result.getNamedObjects());
            context.pushCanvas(canvas);
            PdfRootSvgNodeRenderer root = new PdfRootSvgNodeRenderer(this.result.getRootRenderer());
            root.draw(context);
            this.isGenerated = true;
        }
    }
}

