// helpers.js

const loading = document.getElementById('loading');
const message = document.getElementById('message');

/**
 * Helper to show the loading spinner.
 */
window.showLoading = function() {
	loading.style.display = 'block';
}

/**
 * Helper to hide the loading spinner.
 */
window.hideLoading = function() {
	loading.style.display = 'none';
}

/**
 * Helper to display a status message.
 * @param {string} text - The message text.
 * @param {string} type - 'success' or 'error'.
 */
window.showMessage = function(text, type) {
	message.textContent = text;
	message.className = `message ${type}`;
	message.style.display = 'block';
}

/**
 * Helper to hide the status message.
 */
window.hideMessage = function() {
	message.style.display = 'none';
}

/**
 * Triggers the file download using a Blob and filename.
 * @param {Blob} blob - The file content as a Blob object.
 * @param {string} filename - The name to save the file as.
 */
window.downloadFile = function(blob, filename) {
	const url = window.URL.createObjectURL(blob);
	const a = document.createElement('a');
	a.href = url;
	a.download = filename;
	document.body.appendChild(a);
	a.click();
	window.URL.revokeObjectURL(url);
	document.body.removeChild(a);
}	